/*:
 * @plugindesc This plugin allows you to temporarily stop and resume parallel events with specified names.
 * 
 * @help 
 * Instructions:
 * 
 * 1. Add this script to a new JavaScript plugin file and include it in your project.
 * 2. Call stopParallelEvents() to stop the designated parallel events.
 * 3. Call startParallelEvents() to resume the designated parallel events.
 * 
 * Example Usage:
 * - To stop the events, use stopParallelEvents() in a script call.
 * - To start the events again, use startParallelEvents() in a script call.
 */

(() => {
    // Names of events to be stopped
    const eventNames = ["Crop Spring", "Crop Summer", "Crop Fall"];

    // Function to stop parallel events
    function stopParallelEvents() {
        $gameMap.events().forEach(event => {
            const eventName = event.event().name;
            if (eventNames.includes(eventName)) {
                const currentPage = event.page();
                if (currentPage && !event._isStopped) {
                    event._originalList = currentPage.list;
                    currentPage.list = [{ code: 0 }]; // Clear the event list
                    event._isStopped = true; // Mark the event as stopped
                }
            }
        });
    }

    // Function to start parallel events
    function startParallelEvents() {
        $gameMap.events().forEach(event => {
            const eventName = event.event().name;
            if (eventNames.includes(eventName) && event._isStopped) {
                const currentPage = event.page();
                if (currentPage && event._originalList) {
                    currentPage.list = event._originalList; // Restore the event list
                    delete event._originalList;
                    delete event._isStopped; // Remove the stopped mark
                }
            }
        });
    }

    // Expose the functions to the global scope for easy access
    window.stopParallelEvents = stopParallelEvents;
    window.startParallelEvents = startParallelEvents;
})();

